/**
 * Languages actions for languages page
 *
 * @version 1.0.0
 * @since   9.5.3
 */

window.et_panel = window.et_panel || {};
!function($) {
    $(document).ready(function ($) {
        var buildInlanguage = {
            language_switcher: function (_this, e) {

                var checked = $(_this).is(':checked');
                $(_this).attr("checked", checked);
                $(_this).checked = checked;
                $(_this).parent().toggleClass('switched');

                var data = {
                    action: 'et_panel_ajax',
                    action_type: 'et_built_in_language',
                    value: checked
                };
                $.ajax({
                    type: 'POST',
                    url: ajaxurl,
                    data: data,
                    success: function (response) {
                        location.reload();
                    },
                    error: function () {
                        alert('Error while switching');
                    },
                    complete: function () {
                    }
                });
            },
            language_selector: function (_this, e) {

                var data = {
                    action: 'et_panel_ajax',
                    action_type: 'et_built_in_language_select',
                    language: $('#et_setup-language #language').prop('value')
                };
                $.ajax({
                    type: 'POST',
                    url: ajaxurl,
                    data: data,
                    success: function (response) {
                        location.reload();
                    },
                    error: function () {
                        alert('Ajax error');
                    },
                    complete: function () {
                    }
                });
            },

            remove_not_allowed: function (_this, e) {
                $('.not-allowed').removeClass('not-allowed');
            } 
        };

        window.et_panel = Object.assign(window.et_panel,buildInlanguage);

        var et_buildInlanguage_actions = {
            '1': {
                selector: '#et_language',
                type: 'click',
                callback : et_panel.language_switcher
            },
            '2': {
                selector: '.etheme-language-save:not(.not-allowed)',
                type: 'click',
                callback : et_panel.language_selector
            },
            '3': {
                selector: '#language',
                type: 'change',
                callback : et_panel.remove_not_allowed
            },
        };

        
        $.each(et_buildInlanguage_actions, function (i, t) {
            
            if (t.type == 'ready'){
                $(document).ready(function (e) {
                    t.callback($(this),e);
                });
            } else {
                $(document).on(t.type, t.selector, function (e){
                    t.callback($(this),e);
                    if(t.type != 'change'){
                        $('.etheme-page-wrapper').addClass('loading');
                    }
                });
            }
        });
    });
}(jQuery,window.et_panel);