/**
 * Panel Welcome Demos page scripts
 *
 * @version 1.0.0
 * @since 8.0.6
 */

window.et_panel = window.et_panel || {};
!function($) {

    var et_welcome = {
        welcome_support_refresh: function(_this,e){
            $(document).on('click', '.et_support-refresh', function (e){
                e.preventDefault();
                var _this = $(this),
                    parent = _this.parents('.et_support-block'),
                    status = parent.find('.et_support-status'),
                    temp_msg = $('.temp-msg');

                if (parent.hasClass('processing')){
                    return;
                }
                parent.addClass('processing');
                $.ajax({
                    method: "POST",
                    url: ajaxurl,
                    dataType: 'json',
                    data: {
                        action: 'et_support_refresh'
                    },
                    success: function (data) {
                        if (data.status == 'success' && data.html){
                            status.after($(data.html).find('.et_support-status'));
                            status.remove();
                        }
                        temp_msg.html(data.msg);
                    },
                    complete: function(data) {
                        parent.removeClass('processing');
                        setTimeout(function () {
                            temp_msg.html('');
                        }, 1000);
                        location.reload()
                    },
                    error: function (){
                        parent.removeClass('processing');
                        temp_msg.html('ajax error!');
                    },
                });
            });
        },

        welcome_theme_deactivate: function(_this,e) {
            e.preventDefault();

            var redirect = window.location.href;

            if (_this.hasClass('new-theme-deactivate')){
                jQuery.ajax({
                    type: 'POST',
                    dataType: 'JSON',
                    url: ajaxurl,
                    data: {
                        'action': 'etheme_deactivate_theme',
                        'security':  $(document).find('[name="nonce_etheme-theme-actions"]').val(),
                    },
                    success: function (data) {
                        var out = ''
                        if (data.status == 'deleted' || data.status == 'not_found') {
                            redirect = redirect.replace('_options&tab=1', 'xstore_activation_page');
                            redirect = redirect.replace('_options', 'xstore_activation_page');
                            window.location.href = redirect;
                        } else {
                            //$('#redux-header').prepend('<span class="et_deactivate-error">' + status.msg + '</span>');

                            // global_configuration_functions.openPopup();
                            // $('body').addClass('et_panel-popup-on');
                            jQuery.ajax({
                                type: 'POST',
                                dataType: 'JSON',
                                url: ajaxurl,
                                data: {
                                    'action': 'et_ajax_panel_popup',
                                    'type': 'deregister',
                                    'security':  $(document).find('[name="nonce_etheme-theme-actions"]').val(),
                                },
                                success: function (response) {
                                    $('body').addClass('et_panel-popup-on');
                                    et_panel.popup_configuration.popup.html('').addClass('loading');
                                    et_panel.popup_configuration.popup.prepend(et_panel.popup_configuration.closePopupIcon);
                                    et_panel.popup_configuration.popup.addClass('style-2 panel-popup-theme-deregister').append(response.content);


                                    // et_panel.popup_configuration.popup.html(et_panel.popup_configuration.spinner);

                                    $('.et_close-popup').on('click', function (){
                                        $('.et_theme-deactivator').removeClass('loading');
                                    });

                                    et_panel.popup_configuration.popup.addClass('active').removeClass('loading');
                                    $('.panel-popup-theme-deregister .et_close-popup').on('click', function (){
                                        jQuery.ajax({
                                            type: 'POST',
                                            dataType: 'JSON',
                                            url: ajaxurl,
                                            data: {
                                                'action': 'etheme_deactivate_theme',
                                                'security':  $(document).find('[name="nonce_etheme-theme-actions"]').val(),
                                            },
                                            success: function (data) {
                                                var out = ''
                                                if (data.status == 'deleted') {
                                                    redirect = redirect.replace('_options&tab=1', 'xstore_activation_page');
                                                    redirect = redirect.replace('_options', 'xstore_activation_page');
                                                    window.location.href = redirect;
                                                }
                                            },
                                            error: function (data) {
                                                alert('Error while deactivating');
                                            },
                                        });
                                    });
                                },
                                error: function (data) {
                                    alert('Ajax Error!');
                                },
                            });
                        }
                    },
                    error: function (data) {
                        alert('Error while deactivating');
                    },
                });
            }else{
                if ( ! confirm('Before proceeding with the deactivation of this domain, we want to confirm your decision. As part of our commitment to adhering to Envato\'s policy of 1 live site and 1 staging sites, we manually verify each domain to ensure compliance.') ){
                    setTimeout(
                        function(){
                            _this.removeClass('loading');
                        },
                        300);
                    return;
                }

                jQuery.ajax({
                    type: 'POST',
                    dataType: 'JSON',
                    url: ajaxurl,
                    data: {
                        'action': 'etheme_deactivate_theme',
                        'security':  $(document).find('[name="nonce_etheme-theme-actions"]').val(),
                    },
                    success: function (data) {
                        var out = ''
                        if (data.status == 'deleted') {
                            redirect = redirect.replace('_options&tab=1', 'xstore_activation_page');
                            redirect = redirect.replace('_options', 'xstore_activation_page');
                            window.location.href = redirect;
                        }
                    },
                    error: function (data) {
                        alert('Error while deactivating');
                    },
                });
            }
        },

        welcome_registration_popup: function(_this,e) {
            e.preventDefault();
            var code = $('#purchase-code').val();
            var redirect = window.location.href;

            $('.et-message.et-error').remove();


            jQuery.ajax({
                type: 'POST',
                dataType: 'JSON',
                url: ajaxurl,
                data: {
                    'action': 'etheme_check_activation_data',
                    'purchase_code': code,
                    'security':  $(document).find('[name="nonce_etheme-theme-actions"]').val(),
                    'is_check': 1
                },
                success: function (_data) {
                    if (_data.status != 'error') {
                        // console.log(_data);

                        if(_data.type == 'old_type'){
                            jQuery.ajax({
                                type: 'POST',
                                dataType: 'JSON',
                                url: ajaxurl,
                                data: {
                                    'action': 'etheme_activate_theme',
                                    'purchase_code' : code,
                                    'security':  $(document).find('[name="nonce_etheme-theme-actions"]').val(),
                                },
                                success: function (data) {
                                },
                                error: function (data) {
                                    alert('Error while activation');
                                },
                                complete: function (){
                                    location.reload();
                                },
                            });
                            return;
                        }                      

                        jQuery.ajax({
                            type: 'POST',
                            dataType: 'JSON',
                            url: ajaxurl,
                            data: {
                                'action': 'et_ajax_panel_popup',
                                'type': 'registration',
                                'code': code,
                                'security':  $(document).find('[name="nonce_etheme-theme-actions"]').val(),
                            },
                            success: function (response) {
                                $('body').addClass('et_panel-popup-on');
                                et_panel.popup_configuration.popup.html('').addClass('loading');
                                et_panel.popup_configuration.popup.prepend(et_panel.popup_configuration.closePopupIcon);
                                et_panel.popup_configuration.popup.addClass('style-2 panel-popup-theme-registration').append(response.content);

                                $('.et_close-popup').on('click', function (){
                                    $('.activate-license-btn-holder').removeClass('loading');
                                    // window.location = redirect;
                                    let url = new URL(redirect);
                                    url.searchParams.delete('section-highlighted');
                                    url.searchParams.set('section-focus', 'licence-form');

                                    if ( $('.popup-go-to-import.hidden').length ) {
                                        url.searchParams.set('section-highlighted', '1');
                                    }
                                    window.location = url.href;
                                });

                                et_panel.popup_configuration.popup.addClass('active').removeClass('loading');

                                $('.domain-selector').on('click', function (e){
                                    $(this).find('[name="domain_type"]').trigger('change').prop("checked", true);;
                                    // $(this).find('[name="domain_type"]').checked = true;
                                });

                                $('[name="domain_type"]').on('change', function (e){

                                    let domain_confirm = $('.popup-domain-confirm'),
                                        domain_selectors = $('.domain-selectors');

                                    domain_confirm.removeClass('enabled');
                                    domain_confirm.parents('.tooltip-container').removeClass('active');

                                    $('.domain-selector.active').removeClass('active')
                                    $(this).parents('.domain-selector').addClass('active');

                                    $('.domain-api-error').remove();

                                    if ( $(this).is('#et_register_domain_type_staging')){
                                        // $('.staging-domain-error').addClass('active').removeClass('hidden');
                                        // $('.live-domain-error').removeClass('active').addClass('hidden');
                                        if (
                                            typeof _data.notice != "undefined"
                                            && _data.notice.type == 'staging_domains'
                                        ){
                                            domain_selectors.after('<div class="et-message et-error domain-api-error">' + _data.notice.notice + '</div>');
                                        } else {
                                            domain_confirm.addClass('enabled');
                                            domain_confirm.parents('.tooltip-container').addClass('active');
                                        }

                                        // if($('.staging-domain-error').length){
                                        //     domain_confirm.removeClass('enabled');
                                        // }
                                    } else {
                                        // $('.live-domain-error').addClass('active').removeClass('hidden');
                                        // $('.staging-domain-error').removeClass('active').addClass('hidden');
                                        if (
                                            typeof _data.notice != "undefined"
                                            && _data.notice.type == 'live_domains'
                                        ){
                                            domain_selectors.after('<div class="et-message et-error domain-api-error">' + _data.notice.notice + '</div>');
                                        } else {
                                            domain_confirm.addClass('enabled');
                                            domain_confirm.parents('.tooltip-container').addClass('active');
                                        }

                                        // if($('.live-domain-error').length){
                                        //     domain_confirm.removeClass('enabled');
                                        // }
                                    }
                                });

                                $(document).on( 'click', '.popup-domain-confirm.enabled',function (){
                                    $('.popup-step').addClass('hidden');
                                    $('.popup-step.step-2').removeClass('hidden');
                                    $('.tooltip-trigger').addClass('hidden');
                                    $('.popup-theme-register').removeClass('hidden');
                                });

                                $(document).on( 'click', '.popup-theme-register.enabled',function (){
                                    $('.steps-block-content').addClass('loading');
                                    jQuery.ajax({
                                        type: 'POST',
                                        dataType: 'JSON',
                                        url: ajaxurl,
                                        data: {
                                            'action': 'etheme_activate_theme',
                                            'purchase_code' : code,
                                            'domain_type': $('input[name="domain_type"]:checked').val(),
                                            'security':  $(document).find('[name="nonce_etheme-theme-actions"]').val(),
                                        },
                                        success: function (data) {

                                            if (data.status == 'success'){
                                                $('.popup-step').addClass('hidden');
                                                $('.popup-step.step-3').removeClass('hidden');
                                                $('.tooltip-trigger').addClass('hidden');
                                                $('.popup-go-to-import').removeClass('hidden');
                                            } else {
                                                $('.registration-error').html(data.msg).removeClass('hidden');
                                            }
                                        },
                                        error: function (data) {
                                            alert('Error while activation');
                                        },
                                        complete: function (){
                                            $('.steps-block-content').removeClass('loading');
                                        },
                                    });
                                });

                                $(document).on('click', '.popup-domain-confirm:not(.enabled), .popup-theme-register:not(.enabled)', function(e){
                                    e.preventDefault();
                                    return;
                                });

                                $('.checkbox-steps').on('change', function(e){
                                    var is_checked = $(this).prop('checked'),
                                        section = $(this).parents('.section-block'),
                                        theme_register = $('.popup-theme-register');

                                    if (is_checked) {
                                        section.addClass('enabled');
                                        section.next('.section-block').removeClass('invisible');
                                        $(this).parent().addClass('switched');
                                    } else {
                                        section.removeClass('enabled');
                                        $(this).parent().removeClass('switched');
                                        //section.next('.section-block').removeClass('active');
                                    }
                                    if (
                                        $('#deregister-domain-section-1').prop('checked')
                                        // && $('#deregister-domain-section-2').prop('checked')
                                        // && $('#deregister-domain-section-4').prop('checked')
                                    ) {
                                        theme_register.addClass('enabled');
                                        theme_register.parents('.tooltip-container').addClass('active');
                                    } else {
                                        theme_register.removeClass('enabled');
                                        theme_register.parents('.tooltip-container').removeClass('active');
                                    }
                                });
                            },
                            error: function (data) {
                                alert('Ajax Error!');
                            },
                            complete: function(){
                                $('#purchase-code').val(maskHalfOfStringFromEnd(code));
                                $('.activate-license-btn-holder').removeClass('loading');
                            },
                        });
                    } else {

                        // if(_data.location == 'after_form'){
                            $('#licence-form .xstore-form').after('<br>' + _data.msg);
                            $('#wp-admin-bar-et-panel-license-activation a').trigger('click');
                        // } else {
                            // $('.etheme-panel-page-welcome').prepend(_data.msg);
                        // }

                        $('.activate-license-btn-holder').removeClass('loading');
                    }
                },
                error: function (data) {
                    alert('Error while deactivating');
                },
                complete: function (){
                    // $('#purchase-code').val(maskHalfOfStringFromEnd(code));
                    // $('.activate-license-btn-holder').removeClass('loading');
                },
            });

            function maskHalfOfStringFromEnd(str) {
                const halfLength = Math.floor(str.length / 2);
                const startUnmaskedIndex = str.length - halfLength;
                const maskedPart = '*'.repeat(halfLength);
                const unmaskedPart = str.slice(0, startUnmaskedIndex);
                return unmaskedPart + maskedPart;
            }

        },

        et_theme_refresh: function (_this,e){
            _this.addClass('loading-rotate');
        },
    };


    window.et_panel = Object.assign(window.et_panel,et_welcome);

    var et_welcome_actions = {
        '1': {
            selector: '',
            type: 'ready',
            callback : et_panel.welcome_support_refresh
        },
        '2': {
            selector: '.et_theme-deactivator',
            type: 'click',
            callback : et_panel.welcome_theme_deactivate
        },

        '3': {
            selector: '.activate-license-btn-holder.popup-caller',
            type: 'click',
            callback : et_panel.welcome_registration_popup
        },
        '4': {
            selector: '.et_theme-refresh',
            type: 'click',
            callback : et_panel.et_theme_refresh
        },
    }

    $.each(et_welcome_actions, function (i, t) {
        if (t.type == 'ready'){
            $(document).ready(function (e) {
                t.callback($(this),e);
            });
        } else {
            $(t.selector).on(t.type,function (e){
                t.callback($(this),e);
            });
        }
    });
}(jQuery,window.et_panel);