<?php if ( ! defined( 'ABSPATH' ) ) {
	exit( 'No direct script access allowed' );
}
/**
 * Template "Language" for 8theme dashboard.
 *
 * @since   9.5.3
 * @version 1.0.0
 */
?>

<?php

	$language_page_options = array();
	
    $language_page_options['is_enabled'] = get_option('etheme_builtin_language', false);

    $_is_allowed = ( ! apply_filters('xstore_default_language', get_option('xstore_default_language', false)) ) ? 'allowed' : 'not-allowed'; 
    // $email_builder_page_options['is_enabled_dev_mode'] = get_option('etheme_built_in_email_builder_dev_mode', false);
?>

<h2 class="etheme-page-title etheme-page-title-type-2"><?php echo esc_html__('XStore Built-In Translations', 'xstore'); ?></h2>
<p>
    <?php echo esc_html__('This section provides access to the built-in translation system of the XStore theme. Currently, we include translations for 30+ languages, ready to use without installing any third-party translation plugins.', 'xstore'); ?>
    <br><br>

    <?php echo esc_html__('You can check the full list of available languages', 'xstore'); ?>
    <a href="https://www.8theme.com/glotpress/projects/xstore/xstore/"><?php echo esc_html__('here', 'xstore'); ?></a>.
    <br><br>

    <?php echo esc_html__('Our translation files are community-driven, which means that anyone can', 'xstore'); ?>
    <a href="https://www.8theme.com/glotpress/projects/xstore/xstore/"><?php echo esc_html__('contribute translations', 'xstore'); ?></a>
    <?php echo esc_html__('or improve existing ones for their language. Contributions are reviewed and included in upcoming theme updates.', 'xstore'); ?>
</p>
<p>
	<label class="et-panel-option-switcher<?php if ( $language_page_options['is_enabled']) { ?> switched<?php } ?>" for="et_language">
	    <input type="checkbox" id="et_language" name="et_language" <?php if ( $language_page_options['is_enabled']) { ?>checked<?php } ?>>
	    <span></span>
	</label>
</p>

<?php if ( $language_page_options['is_enabled'] ) : ?>
    <p class="et-message">
        <?php echo esc_html__('Translations activated. Select the language you want to use for your site in the dropdown, then click Save.', 'xstore'); ?>
    </p>

    <?php 
        $ETC_Languages = new ETC_Languages();
        $ETC_Languages->language_select_form();
    ?>
   <p></p>
    <p>
        <input class="etheme-language-save et-button et-button-green no-loader <?php echo esc_html($_is_allowed); ?>" type="submit" value="<?php esc_html_e('save', 'xstore') ?>">
    </p>

    <style>
        .not-allowed{
            border-color: #8c8f94;
            background: #8c8f94;
            cursor: not-allowed;
        }
    </style>

<?php endif; ?>

<?php unset($language_page_options);